/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.test;

import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioArrivalOccurrence;
import filenet.sim.api.VWScenarioArrivalPattern;
import filenet.sim.api.VWScenarioArrivalRecurrence;
import filenet.sim.api.VWScenarioArrivalType;
import filenet.sim.api.VWScenarioConfiguration;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioDurationPattern;
import filenet.sim.api.VWScenarioFieldAssignments;
import filenet.sim.api.VWScenarioOccurrenceType;
import filenet.sim.api.VWScenarioOperationDefinition;
import filenet.sim.api.VWScenarioOrderType;
import filenet.sim.api.VWScenarioPriorityField;
import filenet.sim.api.VWScenarioPriorityType;
import filenet.sim.api.VWScenarioQueueAssignment;
import filenet.sim.api.VWScenarioQueueDefinition;
import filenet.sim.api.VWScenarioResourceAssignment;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioResourcePriorityType;
import filenet.sim.api.VWScenarioResourceType;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.api.VWScenarioScheduleType;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioStepSettings;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioTimeOffset;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioTimeUnitType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowRuntimeId;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TVWScenarioXMLTest
extends TestCase {
    private VWSession m_session = null;
    private VWWorkflowDefinition m_workflowDef = null;
    private String m_scenarioFile = null;
    private boolean m_verbose = false;
    private static final SimpleDateFormat m_dateFormatter = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");

    public TVWScenarioXMLTest(String s) {
        super(s);
    }

    public void testGeneral() throws Exception {
        this.println("");
        this.println("**************************************************");
        this.println("Performing write test.");
        this.println("**************************************************");
        this.println("Creating scenario definition.");
        VWScenarioDefinition scenario = new VWScenarioDefinition();
        scenario.setName("ScenarioAPITest");
        scenario.setDescription("This a scenario definition test.");
        scenario.setCollectAnalysisData(true);
        scenario.setAnimationEnabled(false);
        scenario.setResourcePriority(1);
        scenario.setStartTime(new VWScenarioTimeDuration("5", 3));
        scenario.setEndTime(new VWScenarioTimeOffset("60", 4, 81414));
        scenario.setSeed(new Integer(1));
        scenario.createResource("ctimbreza", 1, 1, 100.0, 1.0f);
        scenario.createResource("Alex", 2, 1, 50.0, 0.5f);
        scenario.createResource("Randy", 1, 1, 75.0, 0.5f);
        VWScenarioShiftDefinition sDef = scenario.createShift("Morning");
        sDef.setStartTime(28800L);
        sDef.setDuration(new VWScenarioTimeDuration("4", 3));
        sDef.setShiftType(1);
        sDef.setScheduleType(2);
        sDef = scenario.createShift("Afternoon");
        sDef.setStartTime(46800L);
        sDef.setDuration(new VWScenarioTimeDuration("4", 3));
        sDef.setShiftType(1);
        sDef.setScheduleType(2);
        VWScenarioRoleDefinition rDef = scenario.createRole("Developer");
        rDef.createQueueAssignment("DeveloperQ1", 3);
        rDef.createQueueAssignment("DeveloperQ2", 0);
        rDef = scenario.createRole("Tester");
        rDef.createQueueAssignment("TesterQ1", 2);
        rDef.createQueueAssignment("TesterQ2", 3);
        rDef = scenario.createRole("Documenter");
        rDef.createQueueAssignment("DocumenterQ1", 3);
        VWScenarioQueueAssignment qa = rDef.createQueueAssignment("DocumenterQ2", 3);
        qa.createPriorityField("IntegerField", 1, 1);
        qa.createPriorityField("FloatField", 8, 2);
        qa.createPriorityField("BooleanField", 4, 1);
        qa.createPriorityField("StringField", 2, 2);
        VWScenarioRoleAssignment ra = scenario.getShift("Morning").createRoleAssignment("Developer");
        ra.createResourceAssignment("ctimbreza", 1.0f);
        ra = scenario.getShift("Morning").createRoleAssignment("Tester");
        ra.createResourceAssignment("Alex", 1.0f);
        ra = scenario.getShift("Morning").createRoleAssignment("Documenter");
        ra.createResourceAssignment("Randy", 1.0f);
        ra = scenario.getShift("Afternoon").createRoleAssignment("Developer");
        ra.createResourceAssignment("Randy", 0.5f);
        ra = scenario.getShift("Afternoon").createRoleAssignment("Tester");
        ra.createResourceAssignment("ctimbreza", 0.5f);
        ra = scenario.getShift("Afternoon").createRoleAssignment("Documenter");
        ra.createResourceAssignment("Alex", 0.5f);
        scenario.getResource("ctimbreza").setName("ctimbreza-renamed");
        scenario.getRole("Developer").setName("Developer-renamed");
        VWWorkflowDefinition wf = this.m_workflowDef;
        VWScenarioWorkflowDefinition scenarioWF = scenario.importWorkflow(wf);
        VWMapDefinition[] maps = wf.getMaps();
        for (int j = 0; j < maps.length; ++j) {
            VWMapNode[] steps = maps[j].getSteps();
            for (int k = 0; k < steps.length; ++k) {
                VWRouteDefinition[] routes;
                VWScenarioStepSettings stepSettings = scenarioWF.getStepSettings(maps[j].getName(), steps[k].getStepId());
                stepSettings.setRoutingType(2);
                if (steps[k] != maps[j].getStartStep()) {
                    stepSettings.setDuration(new VWScenarioTimeDuration("45", 2));
                    stepSettings.setPeriodDuration(new VWScenarioTimeDuration("10", 2));
                    stepSettings.setPauseDuration(new VWScenarioTimeDuration("60", 1));
                    stepSettings.setKeepResource(true);
                }
                if ((routes = steps[k].getNextRoutes()) == null) continue;
                int weight = 100 / routes.length;
                int extraWeight = 0;
                if (weight * routes.length != 100) {
                    extraWeight = 100 - weight * routes.length;
                }
                for (int l = 0; l < routes.length; ++l) {
                    if (l == routes.length - 1) {
                        stepSettings.setRouteWeight(routes[l].getRouteId(), weight + extraWeight);
                        continue;
                    }
                    stepSettings.setRouteWeight(routes[l].getRouteId(), weight);
                }
            }
        }
        String[][] fieldValues = new String[][]{{"IntegerField", "10"}, {"FloatField", "5.5"}};
        VWScenarioArrivalOccurrence occurrence = new VWScenarioArrivalOccurrence(1, "5", null, new VWScenarioTimeDuration("60", 2), new VWScenarioTimeDuration("8", 3));
        VWScenarioArrivalRecurrence recurrence = new VWScenarioArrivalRecurrence("1000", new VWScenarioTimeOffset("1", 4, 28800), null);
        scenarioWF.createArrival("UserDefinedArrival", new VWScenarioTimeDuration("0", 1), occurrence, recurrence, fieldValues);
        TVWScenarioXMLTest.assertTrue((String)"Validation failed", (boolean)this.validate(scenario));
        if (this.m_session != null) {
            this.println("Writing runtime scenario definition to file: " + this.m_scenarioFile);
            StringBuffer buffer = new StringBuffer();
            scenario.toRuntimeXML(this.m_session, buffer);
            PrintWriter outFile = null;
            try {
                outFile = new PrintWriter(new BufferedWriter(new FileWriter(this.m_scenarioFile, false)));
                outFile.println(buffer.toString());
                outFile.flush();
                outFile.close();
            }
            catch (IOException e) {
                if (outFile != null) {
                    outFile.close();
                }
                throw e;
            }
        } else {
            this.println("Writing standard scenario definition to file: " + this.m_scenarioFile);
            scenario.writeToFile(this.m_scenarioFile);
        }
        scenario = null;
        scenario = VWScenarioDefinition.readFromFile(this.m_scenarioFile);
        TVWScenarioXMLTest.assertTrue((String)"Validation failed", (boolean)this.validate(scenario));
        this.printScenario(scenario);
    }

    public void testTimeConversion() throws Exception {
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(81414), (String)"10:36:54 PM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("10:36:54 PM"), (int)81414);
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(38214), (String)"10:36:54 AM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("10:36:54 AM"), (int)38214);
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(32764), (String)"09:06:04 AM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("09:06:04 AM"), (int)32764);
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(3964), (String)"01:06:04 AM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("01:06:04 AM"), (int)3964);
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(0), (String)"12:00:00 AM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("12:00:00 AM"), (int)0);
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(43200), (String)"12:00:00 PM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("12:00:00 PM"), (int)43200);
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(43140), (String)"11:59:00 AM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("11:59:00 AM"), (int)43140);
        TVWScenarioXMLTest.assertEquals((String)VWScenarioXMLHandler.convertTimeValue(86340), (String)"11:59:00 PM");
        TVWScenarioXMLTest.assertEquals((int)VWScenarioXMLHandler.convertTimeValue("11:59:00 PM"), (int)86340);
    }

    private void println(String message) {
        if (this.m_verbose) {
            System.out.println(message);
        }
    }

    private VWScenarioDefinition writeReadScenario(VWScenarioDefinition scenario) throws Exception {
        File file = File.createTempFile("Scenario", "esd");
        file.deleteOnExit();
        scenario.writeToFile(file.getPath());
        return VWScenarioDefinition.readFromFile(file.getPath());
    }

    private boolean compare(VWScenarioFieldAssignments fa1, VWScenarioFieldAssignments fa2) {
        if (!fa1.equals(fa2)) {
            return false;
        }
        if (!fa1.getInputFields().equals(fa2.getInputFields())) {
            return false;
        }
        return fa1.getDefaultOutputs().equals(fa2.getDefaultOutputs());
    }

    private void createProcessQueues(ArrayList queueNames) throws VWException {
        if (this.m_session != null) {
            this.println("Creating process queues.");
            VWSystemConfiguration config = null;
            for (int i = 0; i < queueNames.size(); ++i) {
                try {
                    this.m_session.getQueue((String)queueNames.get(i));
                    continue;
                }
                catch (VWException e) {
                    if (config == null) {
                        config = this.m_session.fetchSystemConfiguration();
                    }
                    config.createQueueDefinition((String)queueNames.get(i), 1);
                }
            }
            if (config != null) {
                config.commit();
            }
        }
    }

    public void printScenario(VWScenarioDefinition scenario) throws Exception {
        this.println("");
        this.println("**************************************************");
        this.println("Scenario Definition Summary.");
        this.println("**************************************************");
        this.println("Name: " + scenario.getName());
        this.println("Description: " + scenario.getDescription());
        this.println("Start time: " + this.timeObjectToString(scenario.getStartTime()));
        this.println("End time: " + this.timeObjectToString(scenario.getEndTime()));
        this.println("Animation enabled: " + scenario.getAnimationEnabled());
        this.println("Collect analysis data: " + scenario.getCollectAnalyisData());
        this.println("Seed: " + scenario.getSeed());
        this.println("Resource priority: " + VWScenarioResourcePriorityType.getLocalizedString(scenario.getResourcePriority()));
        this.printWorkflows(scenario);
        this.printShifts(scenario);
        this.printRoles(scenario);
        this.printResources(scenario);
        this.printConfiguration(scenario);
    }

    private void printWorkflows(VWScenarioDefinition scenario) throws Exception {
        VWScenarioWorkflowDefinition[] swfs = scenario.getWorkflows();
        this.println("");
        this.println("=====================");
        this.println("Workflows.");
        this.println("=====================");
        if (swfs == null) {
            this.println("No workflows have been imported into the scenario.");
            return;
        }
        for (int i = 0; i < swfs.length; ++i) {
            VWScenarioDurationPattern dPattern;
            VWWorkflowDefinition wf = swfs[i].getWorkflowDefinition();
            VWMapDefinition[] maps = wf.getMaps();
            VWMapNode[] steps = null;
            VWRouteDefinition[] routes = null;
            VWScenarioStepSettings stepSettings = null;
            this.println("");
            this.println("Workflow name: " + wf.getName());
            VWWorkflowRuntimeId runtimeId = wf.getRuntimeId();
            if (runtimeId != null) {
                this.println("Workflow runtime id: " + runtimeId);
                this.println("Service name: " + runtimeId.getServiceName());
                this.println("Region: " + runtimeId.getIsolatedRegion());
                this.println("Workclass id: " + runtimeId.getWorkClassId());
            }
            if ((dPattern = swfs[i].getDurationPattern()) != null) {
                this.println("\n\t=====================");
                this.println("\tProduction Duration Settings");
                this.println("\t=====================");
                this.println("\tStart time: " + this.timeObjectToString(dPattern.getAcquireStartTime()));
                this.println("\tEnd time: " + this.timeObjectToString(dPattern.getAcquireEndTime()));
                this.println("\tAdjust factor: " + dPattern.getAdjustFactor());
            }
            for (int j = 0; j < maps.length; ++j) {
                this.println("\n\t=====================");
                this.println("\tStep Settings (Map " + maps[j].getName() + ")");
                this.println("\t=====================");
                steps = maps[j].getSteps();
                for (int k = 0; k < steps.length; ++k) {
                    stepSettings = swfs[i].getStepSettings(maps[j].getName(), steps[k].getStepId());
                    this.println("\n\tStep name: " + steps[k].getName());
                    this.println("\tDuration: " + this.timeObjectToString(stepSettings.getDuration()));
                    this.println("\tPeriod Duration: " + this.timeObjectToString(stepSettings.getPeriodDuration()));
                    this.println("\tPause Duration: " + this.timeObjectToString(stepSettings.getPauseDuration()));
                    this.println("\tKeep Resource: " + stepSettings.getKeepResource());
                    if (stepSettings.getRoutingType() != 2 || (routes = steps[k].getNextRoutes()) == null) continue;
                    this.println("\tRoutes: ");
                    for (int l = 0; l < routes.length; ++l) {
                        this.println("\t\tId: " + routes[l].getRouteId() + "\tWeight: " + stepSettings.getRouteWeight(routes[l].getRouteId()));
                    }
                }
            }
            Object[] arrivals = swfs[i].getArrivals(3);
            if (arrivals == null) continue;
            for (int j = 0; j < arrivals.length; ++j) {
                int arrivalType = VWScenarioArrivalType.getArrivalType(arrivals[j]);
                if (arrivalType == 1) {
                    String[][] fields;
                    VWScenarioArrivalRecurrence rec;
                    VWScenarioArrivalDefinition arrivalDef = (VWScenarioArrivalDefinition)arrivals[j];
                    this.println("\n\t=====================");
                    this.println("\tArrivals.");
                    this.println("\t=====================");
                    this.println("\tName: " + arrivalDef.getName());
                    this.println("\ttoString: " + arrivalDef.toString());
                    this.println("\tStart time: " + this.timeObjectToString(arrivalDef.getStartTime()));
                    VWScenarioArrivalOccurrence occ = arrivalDef.getOccurrence();
                    if (occ != null) {
                        this.println("\tOccurrence:");
                        this.println("\t\tType: " + VWScenarioOccurrenceType.getLocalizedString(occ.getType()));
                        this.println("\t\tQuantity: " + occ.getQuantity());
                        this.println("\t\tInterval: " + this.timeObjectToString(occ.getTimeInterval()));
                        this.println("\t\tMax count: " + occ.getMaxCount());
                        this.println("\t\tEnd time: " + this.timeObjectToString(occ.getEndTime()));
                    }
                    if ((rec = arrivalDef.getRecurrence()) != null) {
                        this.println("\tRecurrence:");
                        this.println("\t\tInterval: " + this.timeObjectToString(rec.getTimeInterval()));
                        this.println("\t\tMax count: " + rec.getMaxCount());
                        this.println("\t\tEnd time: " + this.timeObjectToString(rec.getEndTime()));
                    }
                    if ((fields = arrivalDef.getFieldAssignments()) == null) continue;
                    this.println("\tFields:");
                    for (int k = 0; k < fields[0].length; ++k) {
                        this.println("\t\t" + fields[k][0] + "\t" + fields[k][1]);
                    }
                    continue;
                }
                VWScenarioArrivalPattern arrivalPattern = (VWScenarioArrivalPattern)arrivals[j];
                this.println("");
                this.println("\t=====================");
                this.println("\tProduction arrivals.");
                this.println("\t=====================");
                this.println("\tName: " + arrivalPattern.getName());
                this.println("\ttoString: " + arrivalPattern.toString());
                this.println("\tStart date: " + this.timeObjectToString(arrivalPattern.getAcquireStartTime()));
                this.println("\tEnd date: " + this.timeObjectToString(arrivalPattern.getAcquireEndTime()));
                this.println("\tSim start date: " + this.timeObjectToString(arrivalPattern.getStartTime()));
            }
        }
    }

    private void printShifts(VWScenarioDefinition scenario) throws Exception {
        VWScenarioShiftDefinition[] shifts = scenario.getShifts();
        VWScenarioResourceAssignment[] resources = null;
        VWScenarioRoleAssignment[] roles = null;
        this.println("=====================");
        this.println("Shifts.");
        this.println("=====================");
        if (shifts == null) {
            this.println("No shifts have been defined for this scenario.");
            return;
        }
        for (int i = 0; i < shifts.length; ++i) {
            this.println("");
            this.println("Shift name: " + shifts[i].getName());
            this.println("toString: " + shifts[i].toString());
            if (shifts[i].getScheduleType() == 1) {
                this.println("Start time: " + new Date(shifts[i].getStartTime()));
            } else {
                this.println("Start time: " + VWScenarioXMLHandler.convertTimeValue((int)shifts[i].getStartTime()));
            }
            this.println("Duration: " + this.timeObjectToString(shifts[i].getDuration()));
            this.println("Start interval: " + shifts[i].getStartInterval());
            this.println("Every interval: " + shifts[i].getEveryInterval());
            this.println("Occur interval: " + shifts[i].getOccurrencesInterval());
            this.println("Schedule Type: " + VWScenarioScheduleType.getLocalizedString(shifts[i].getScheduleType()));
            this.println("Active days: " + shifts[i].getActiveDays());
            roles = shifts[i].getRoleAssignments();
            if (roles != null) {
                for (int j = 0; j < roles.length; ++j) {
                    this.println("\tRole name: " + roles[j].getRoleName());
                    resources = roles[j].getResourceAssignments();
                    if (resources == null) continue;
                    for (int k = 0; k < resources.length; ++k) {
                        this.println("\n\t\tResource name: " + resources[k].getResourceName());
                        this.println("\t\tPerformance: " + resources[k].getPerformance());
                    }
                }
                continue;
            }
            this.println("No roles have been assigned to this shift.");
        }
    }

    private void printRoles(VWScenarioDefinition scenario) throws Exception {
        VWScenarioRoleDefinition[] roles = scenario.getRoles();
        VWScenarioQueueAssignment[] queues = null;
        this.println("=====================");
        this.println("Roles.");
        this.println("=====================");
        if (roles == null) {
            this.println("No roles have been defined for this scenario.");
            return;
        }
        for (int i = 0; i < roles.length; ++i) {
            this.println("");
            this.println("Role name: " + roles[i].getName());
            this.println("Role toString: " + roles[i].toString());
            queues = roles[i].getQueueAssignments();
            if (queues != null) {
                for (int j = 0; j < queues.length; ++j) {
                    VWScenarioPriorityField[] fields;
                    this.println("\n\tQueue name: " + queues[j].getQueueName());
                    this.println("\tQueue toString: " + queues[j].toString());
                    this.println("\tType: " + VWScenarioPriorityType.getLocalizedString(queues[j].getPriorityType()));
                    if (queues[j].getPriorityType() != 1 || (fields = queues[j].getPriorityFields()) == null) continue;
                    this.println("\t\tFields:");
                    for (int k = 0; k < fields.length; ++k) {
                        this.println("\t\t\tName: " + fields[k].getName() + "\tType: " + VWFieldType.getLocalizedString(fields[k].getFieldType()) + "\tOrder: " + VWScenarioOrderType.getLocalizedString(fields[k].getOrderType()));
                        this.println("\t\t\tField toString: " + fields[k].toString());
                    }
                }
                continue;
            }
            this.println("No queues have been assigned to this role.");
        }
    }

    private void printResources(VWScenarioDefinition scenario) throws Exception {
        VWScenarioResourceDefinition[] resources = scenario.getResources();
        this.println("=====================");
        this.println("Resources.");
        this.println("=====================");
        if (resources == null) {
            this.println("No resources have been defined for this scenario.");
            return;
        }
        for (int i = 0; i < resources.length; ++i) {
            this.println("");
            this.println("Name: " + resources[i].getName());
            this.println("toString: " + resources[i].toString());
            this.println("Id: " + resources[i].getId());
            this.println("Type: " + VWScenarioResourceType.getLocalizedString(resources[i].getType()));
            this.println("Quantity: " + resources[i].getQuantity());
            this.println("Cost: " + resources[i].getCost());
            this.println("Performance: " + resources[i].getPerformance());
        }
    }

    private boolean validate(VWScenarioDefinition scenario) throws Exception {
        VWScenarioValidationError[] errors;
        this.println("");
        this.println("=====================");
        this.println("Scenario Validation.");
        this.println("=====================");
        if (this.m_session != null) {
            this.println("Using VWSession to do validation.");
        }
        if ((errors = scenario.validate(this.m_session, true, true)) != null) {
            for (int i = 0; i < errors.length; ++i) {
                this.println(errors[i].toString());
            }
            return false;
        }
        this.println("Validation successfull.");
        return true;
    }

    private String timeObjectToString(Object timeObj) throws VWException {
        if (timeObj == null) {
            return "null";
        }
        switch (VWScenarioTimeType.getTimeType(timeObj)) {
            case 1: {
                return m_dateFormatter.format((Date)timeObj);
            }
            case 2: {
                VWScenarioTimeDuration duration = (VWScenarioTimeDuration)timeObj;
                return "Duration [" + duration.getDuration() + " " + VWScenarioTimeUnitType.getLocalizedString(duration.getUnits()) + "]";
            }
            case 3: {
                VWScenarioTimeOffset offset = (VWScenarioTimeOffset)timeObj;
                return "Offset [" + offset.getOffset() + " " + VWScenarioTimeUnitType.getLocalizedString(offset.getUnits()) + " " + VWScenarioXMLHandler.convertTimeValue(offset.getTime()) + "]";
            }
        }
        return "INVALID TIME OBJECT";
    }

    private void printConfiguration(VWScenarioDefinition scenario) throws Exception {
        this.println("");
        this.println("**************************************************");
        this.println("Config XML.");
        this.println("**************************************************");
        VWScenarioConfiguration config = scenario.getConfiguration();
        if (config == null) {
            this.println("No configuration information defined.");
        } else {
            this.println("Service name: " + config.getServiceName());
            this.println("Region id: " + config.getIsolatedRegion());
            this.println("Queues:");
            VWScenarioQueueDefinition[] queues = config.getQueues();
            if (queues != null) {
                for (int i = 0; i < queues.length; ++i) {
                    this.println("");
                    this.println("\tName: " + queues[i].getName());
                    this.println("\tId: " + queues[i].getId());
                    this.println("\tOperations:");
                    VWScenarioOperationDefinition[] ops = queues[i].getOperations();
                    if (ops == null) continue;
                    for (int j = 0; j < ops.length; ++j) {
                        this.println("\t\tName: " + ops[j].getName());
                        this.println("\t\tId: " + ops[j].getId());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() {
        InputStream is = null;
        try {
            String queues;
            is = TVWScenarioXMLTest.class.getResourceAsStream("TVWScenarioXMLTest.properties");
            Properties props = new Properties();
            props.load(is);
            this.m_verbose = new Boolean(props.getProperty("Verbose"));
            String userName = props.getProperty("UserName");
            String password = props.getProperty("Password");
            String routerURL = props.getProperty("RouterURL");
            if (userName != null && password != null && routerURL != null) {
                if (password.compareTo("\"\"") == 0) {
                    password = "";
                }
                this.println("Logging on.");
                this.m_session = new VWSession(userName, password, routerURL);
                this.println("Logged on successfully.");
            }
            this.m_workflowDef = VWWorkflowDefinition.readFromFile(props.getProperty("WorkflowDefinition"));
            this.m_scenarioFile = props.getProperty("ScenarioFile");
            if (this.m_session != null && (queues = props.getProperty("RequiredQueues")) != null) {
                ArrayList<String> list = new ArrayList<String>();
                StringTokenizer tokens = new StringTokenizer(queues, ",", false);
                while (tokens.hasMoreTokens()) {
                    list.add(tokens.nextToken());
                }
                this.createProcessQueues(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TVWScenarioXMLTest.fail((String)("Exception during setup: " + e.getLocalizedMessage()));
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TVWScenarioXMLTest.class);
        return suite;
    }

    public static void main(String[] args) {
        try {
            TestRunner.run((Test)TVWScenarioXMLTest.suite());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

